#!/usr/bin/env bash

# ---
# Arguments
# ---

instanceNumber=$1
numberOfServers=$2
regionName=$3

# ---
# Consul configuration
# ---

cat > /etc/consul.d/consul.hcl <<EOF
datacenter = "dc-$regionName-1"
data_dir = "/opt/consul"

node_name = "consul-client-$instanceNumber"

bind_addr = "0.0.0.0"
client_addr = "0.0.0.0"
advertise_addr = "10.8.0.$instanceNumber"

retry_join = [
EOF

for SERVER_NUMBER in $(seq 1 $numberOfServers); do
    echo "    \"10.8.0.$SERVER_NUMBER\"," >> /etc/consul.d/consul.hcl
done

cat >> /etc/consul.d/consul.hcl <<EOF
]

connect {
    enabled = true
}

ports {
    grpc = 8502
}
EOF

# ---
# Nomad configuration
# ---

cat > /etc/nomad.d/nomad.hcl <<EOF
datacenter = "dc-$regionName-1"
data_dir = "/opt/nomad/data"

bind_addr = "0.0.0.0"

name = "nomad-client-$instanceNumber"

client {
    enabled = true
    options {
        "driver.raw_exec.enable" = "1"
        "docker.privileged.enabled" = "true"
    }
}

consul {
    address = "127.0.0.1:8500"
}

ui {
    enabled = false
}
EOF

# ---
# Running Consul
# ---
systemctl enable consul
systemctl start consul

# ---
# Running Nomad
# ---
systemctl enable nomad
systemctl start nomad
